/**********************************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 2023.5.8
* Description : 这个例程将用查询的方式采集FVR1.0电压
//              1）采集FVR，反推VDD
//				ADC使用时，注意事项
//				1）切换通道和参考电压，需要执行几次空转换，AD值才能稳定
//
***********************************************************************************************/
#include "AD18F08.h"
#include <stdio.h>
#include "periph.h"
#include "usart.h"

/*********************************************************************************************
*
* _FINTOSC_DIV1   :  内部RC振荡器频率选择
* _DBG_OFF        :  DEBUG模式使能位
* _LVREN_OFF       :  禁止LVR
* _LVR24V         :  LVR的电压选择为2.4V
* _FLASH_CP1_OFF  :  1K~2K*16 FLASH CP保护
* _FLASH_CP0_OFF  :  0~1K*16 FLASH CP保护
* _IDIS_OFF		    :  模拟IO打开，数据读取控制位
* _CKSUM_OFF      :  校验使能位
* _CBP_OFF		    :  代码保护选择位
* _RESETE_OFF     :  外部复位使能
* _RSEL			      :  端口上下拉电阻选择
* _STV_ON		      :  堆栈溢出复位
* _PSUT_2		      :  上电复位时间选择
* _FCPU_4T        :  指令周期选择4T
* _WDTE_OFF       :  看门狗使能
* _TWDT_000       :  看门狗溢出时间选择
* _OSCM_HIRC_16M  :  系统时钟选择高速时钟
* _MTPDIS_OFF     :  SWD模式下读FALSH控制
* _ADCSP_ON		    :	 ADC采集速度选择
*

************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                   );


void ADC_SampleVDD(void);

volatile unsigned short Vol_VDD = 0;		//VDD电压值（mV）
volatile unsigned short AD_VDD  = 0;		//反推VDD的AD值（VDD做参考，FVR1.0V的AD值）
//==============================================================================================
// ----Function: 主函数
// --Parameters: None
// -----Returns: None
//---------Note: 这个例程将用查询的方式采集FVR1.0电压
//				 	1）采集FVR，反推VDD
//				 ADC使用时，注意事项
//					1）切换通道和参考电压，需要执行几次空转换，AD值才能稳定
//**********************************************************************************************
//==============================================================================================

void main(void)
{
    GPIO_Init();//GPIO 初始化
    usart_init();
    ADC_Config();  //ADC的基准选择VDD,采集通道为FVROUT；
    fvr_int();     //FVR的配置，选择VREF1P0(1.0V)通道

    printf("AD18F08_ADC_test\r\n");

    while(1)
    {
		ADC_SampleVDD();
		printf("VDD = %4dmV,", Vol_VDD);		//Vol_VDD-转换过来的VDD电压值
		printf(" %4d --- \r\n", AD_VDD);			//AD_VDD-实际采集的ADC值
    }
}
//中断服务函数
//高优先中断服务函数
void interrupt ISR_h(void)
{
     if(ADIE&&ADIF)
     {
       ADIF = 0;
       TRISB0  = 0;//设置PB0为输出模式
       PB0      = ~PB0; //用于检测ADC是否产生中断
     }
}
//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{


}

/*******************************************************************************
* Description    : AD采集FVR1.0V电压值，反推VDD电压
* Input          : None
* Output         : None
* Return         : None
* Note           :
*******************************************************************************/
void ADC_SampleVDD(void)
{
    volatile unsigned long Sum;
    volatile unsigned short ADData;
	volatile unsigned char  i;


    //空转换10次
	for(i=0; i<10; i++)
	{
        ADC_Exce();
	}
    //启动AD转换
	Sum = 0;
	for(i=0; i<16; i++)
	{
        ADC_Exce();

        //读取转换结果
        ADData = (ADRESH<<8)|ADRESL;
        Sum += ADData;
	}
	// 电压单位1mV
	AD_VDD  = Sum >> 4;
	Vol_VDD = 4096000 / AD_VDD;		//VCC采集1.0V电压：4096000=4096*1000
}

